//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.Runtime.Serialization.Formatters.Soap;

namespace MultiLevel
{
	[Serializable]
	public class Person
	{
		public string name;
		public double age;
	}

	[Serializable]
	public class Marriage
	{
		public Person husband;
		public Person wife;
	}

	[Serializable]
	public class Family
	{
		public Marriage couple;
		public Person [] children;
	}

	/// <summary>
	///    Podsumowanie dla MultiLevelSerialization.
	/// </summary>
	public class MultiLevelSerialization
	{
		public static int Main(string[] args)
		{
			Person me = new Person();
			me.age = 43;
			me.name = "Kevin Burton";

			Person wife = new Person();
			wife.age = 50;
			wife.name = "Becky Burton";

			Marriage marriage = new Marriage();
			marriage.husband = me;
			marriage.wife = wife;

			Family family = new Family();
			family.couple = marriage;

			family.children = new Person[4];
			family.children[0] = new Person();
			family.children[0].age = 20;
			family.children[0].name = "Sarah";
			family.children[1] = new Person();
			family.children[1].age = 18;
			family.children[1].name = "Ann Marie";
			family.children[2] = new Person();
			family.children[2].age = 17;
			family.children[2].name = "Mike";
			family.children[2] = new Person();
			family.children[2].age = 13;
			family.children[2].name = "Rose";

			Stream stream = File.Create("out.xml");
			SoapFormatter soap = new SoapFormatter();
			soap.Serialize(stream, family);
			stream.Close();

			stream = File.OpenRead("out.xml");
			soap = new SoapFormatter();
			family = (Family)soap.Deserialize(stream);
			stream.Close();

			return 0;
		}
	}
}
